﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.Runtime.Serialization;

namespace BMS.DataContracts
{
    /// <summary>
    /// Icon Info class used for listing icons association.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "IconAssociationInfo")]
    [DataContract(Name = "IconAssociationInfo")]
    public class IconAssociationInfo
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the icon id.
        /// </summary>
        /// <value>
        /// The icon id.
        /// </value>
        [XmlElementAttribute("IconId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "IconId", Order = 1)]
        public int IconId { get; set; }

        /// <summary>
        /// Gets or sets the group.
        /// </summary>
        /// <value>
        /// The group.
        /// </value>
        [XmlElementAttribute("Group", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "Group", Order = 2)]
        public string Group { get; set; }

        /// <summary>
        /// Gets or sets the subgroup.
        /// </summary>
        /// <value>
        /// The subgroup.
        /// </value>
        [XmlElementAttribute("Subgroup", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "Subgroup", Order = 3)]
        public string Subgroup { get; set; }

        #endregion
    }
}
